import pandas as pd

# Definir el contenido para el plan de entrenamiento ajustado con el nuevo ritmo
plan_entrenamiento = {
    "Semana": [],
    "Día": [],
    "Objetivo": [],
    "Ejercicio/Descripción": [],
    "Duración/Series/Repeticiones": [],
    "Notas (Técnica/Intensidad)": []
}

# Actividades y objetivos para cada día de entrenamiento
dias_entrenamiento = [
    ("Lunes", "Trabajo de tiempos (mejorar velocidad por vuelta)", "Reducir tiempo por vuelta a 21s", [
        ("Calentamiento", "20 min (5 min trote suave, 10 min patinaje progresivo, 5 min técnica)", "Aumentar movilidad y control"),
        ("Parte principal", "1x8 vueltas a ritmo de 23s, 2x4 vueltas rápidas (22s)", "Controlar el ritmo, enfocarse en mantener velocidad"),
        ("Vuelta a la calma", "10 min de patinaje suave, estiramientos", "Recuperar y estirar piernas")
    ]),
    ("Martes", "Técnica de patinaje", "Mejorar eficiencia en la pista", [
        ("Calentamiento", "20 min (trote suave y patinaje progresivo)", "Activar el cuerpo y mejorar postura"),
        ("Parte principal", "3x3 curvas rápidas, 2x5 salidas rápidas, 4x3 repeticiones de un solo pie", "Enfocarse en transferir peso y postura baja"),
        ("Vuelta a la calma", "10 min de patinaje suave y estiramientos", "Relajar el cuerpo")
    ]),
    ("Miércoles", "Resistencia + Gimnasio", "Mejorar resistencia y fortalecer músculos", [
        ("Parte 1", "1x6 vueltas (24-25s por vuelta), 1x8 vueltas a ritmo de competencia", "Mejorar resistencia para mantener ritmo alto"),
        ("Parte 2", "Sentadillas, Puentes de glúteos, Zancadas, Flexiones", "Fortalecer piernas y core para mayor explosividad"),
        ("Vuelta a la calma", "10 min de estiramientos", "Estirar adecuadamente después de la carga")
    ]),
    ("Viernes", "Salidas y velocidad pura", "Mejorar explosividad en salidas y velocidad máxima", [
        ("Calentamiento", "20 min (trote suave, patinaje progresivo)", "Activar el cuerpo"),
        ("Parte principal", "6x30 m salidas explosivas, 3x2 vueltas rápidas a 22-23s", "Focalizar en la explosividad desde la salida"),
        ("Vuelta a la calma", "10 min de patinaje relajado y estiramientos", "Relajar el cuerpo y recuperar")
    ]),
    ("Domingo", "Resistencia en trote", "Aumentar base aeróbica para mejorar la resistencia", [
        ("Trote suave", "20-30 min trote progresivo", "Mejorar resistencia cardiovascular para mantener ritmo alto"),
        ("Trote moderado", "40 min trotando continuo", "Mantener ritmo constante y cómodo"),
        ("Trote largo", "45-60 min trotando", "Aumentar distancia para mejorar la capacidad aeróbica")
    ])
]

# Añadir el plan de entrenamiento para cada semana (repetir los ejercicios para las 12 semanas)
for semana in range(1, 13):
    for dia, objetivo, descripcion, ejercicios in dias_entrenamiento:
        for ejercicio, duracion, notas in ejercicios:
            plan_entrenamiento["Semana"].append(f"Semana {semana}")
            plan_entrenamiento["Día"].append(dia)
            plan_entrenamiento["Objetivo"].append(objetivo)
            plan_entrenamiento["Ejercicio/Descripción"].append(ejercicio)
            plan_entrenamiento["Duración/Series/Repeticiones"].append(duracion)
            plan_entrenamiento["Notas (Técnica/Intensidad)"].append(notas)

# Crear el DataFrame
df_plan_entrenamiento = pd.DataFrame(plan_entrenamiento)

# Guardar el archivo Excel
ruta_archivo_plan_entrenamiento = 'C:\\Users\\jsnun\\OneDrive\\Documentos\\cpc\\sinaptico actual\\innovacion\\Plan_Entrenamiento_3_Meses.xlsx'
df_plan_entrenamiento.to_excel(ruta_archivo_plan_entrenamiento, index=False)

ruta_archivo_plan_entrenamiento