import express from "express";
import entidadRoutes from './routes/entidadRoutes.js';  // Importar las rutas
import cargoRoutes from './routes/cargoRoutes.js';  // Importar las rutas
import departamenoRoutes from './routes/departamentoRoutes.js';  // Importar las rutas
import ciudadRoutes from './routes/ciudadRoutes.js';  // Importar las rutas
import ContactoRoutes from './routes/contactoRoutes.js';  // Importar las rutas
import UserRoutes from "./routes//userRoutes.js";
import UsuarioEmpresaCargoRoutes from "./routes/UsuarioEmpresaCargoRoutes.js";  // Importar las rutas
import authRoutes from './routes/authRoutes.js';  // Importar las rutas
import RetoRoutes from './routes/retosRoutes.js';  // Importar las rutas
import cookieParser from 'cookie-parser';
import multer from "multer";
import sequelize from './config/database.js';  // Importa la conexión de Sequelize
//Fix para __direname
import path from 'path';
import { fileURLToPath } from 'url';
const __dirname = path.dirname(fileURLToPath(import.meta.url));
import { methods as authentication } from "./controllers/authentication.controller.js"
import { methods as authorization } from "./middlewares/authorization.js";
import User from './models/user.js';
import Empresa from './models/entidad.js';
import Contacto from './models/contacto.js';
import Cargo from "./models/cargo.js";
import Departamento from "./models/departamento.js";
import Ciudad from "./models/ciudad.js";
import UsuarioEmpresaCargo from "./models/UsuarioEmpresaCargo.js"
import Reto from "./models/reto.js";
import AplicarReto from "./models/aplicarReto.js";
import cors from 'cors';

// Configuración de CORS


// Configuración de almacenamiento con multer
const storage = multer.diskStorage({
    destination: function (req, file, cb) {
        cb(null, 'app/public/logos'); // Carpeta donde se guardarán los archivos
    },
    filename: function (req, file, cb) {
        const empresaNombre = req.body.numIdentificacion; // Obtener el nombre de la empresa
        const fileExtension = path.extname(file.originalname); // Obtener la extensión del archivo (e.g., .jpg, .png)


        cb(null, empresaNombre + fileExtension); // Asignar el nuevo nombre al archivo
    }
});

// Configurar multer
const upload = multer({ storage: storage });  // Configuración del middleware multer

//Server
const app = express();
// app.set("port",4000);
// app.listen(app.get("port"));
// console.log("Servidor corriendo en puerto",app.get("port"));
const corsOptions = {
    origin: '*', // Permitir todas las solicitudes de cualquier origen
    methods: ['GET', 'POST', 'PUT', 'DELETE'], // Métodos permitidos
    credentials: true // <-- esto permite enviar cookies/cabeceras de sesión
};

app.use(cors({ origin: 'http://127.0.0.1:5500', credentials: true }));
//Configuración
app.use(express.static(__dirname + "/public"));
app.use(express.json());
app.use(cookieParser())

app.use('/api/entidad', entidadRoutes);
app.use('/api/cargos', cargoRoutes);
app.use('/api/departamentos', departamenoRoutes);
app.use('/api/ciudades', ciudadRoutes);
app.use('/api/contactos', ContactoRoutes);
app.use('/api/usuarioempresa', UsuarioEmpresaCargoRoutes);
app.use('/api/validarToken', authRoutes);
app.use('/api/user', UserRoutes);
app.use('/api/retos', RetoRoutes); // Ruta para los retos
//Rutas
app.get("/", authorization.soloPublico, (req, res) => res.sendFile(__dirname + "/pages/home.html"));
app.get("/register", authorization.soloPublico, (req, res) => res.sendFile(__dirname + "/pages/register.html"));
// app.get("/crearentidad", authorization.soloUser, (req, res) => res.sendFile(__dirname + "/pages/User/crearentidad.html"));
app.get("/reestablecerpass", authorization.soloPublico, (req, res) => res.sendFile(__dirname + "/pages/restablecer.html"));
app.get("/helice", authorization.soloUser, (req, res) => res.sendFile(__dirname + "/pages/User/helice.html"));
app.get("/innovacion", authorization.soloUser, (req, res) => res.sendFile(__dirname + "/pages/User/innovacion.html"));
app.get("/crearReto", authorization.soloAdmin, (req, res) => res.sendFile(__dirname + "/pages/admin/crearReto.html"));
app.get("/dashboard", authorization.soloAdmin, (req, res) => res.sendFile(__dirname + "/pages/admin/dashboard.html"));
app.get("/entidades", authorization.soloAdmin, (req, res) => res.sendFile(__dirname + "/pages/admin/entidades.html"));

app.get("/usuarios", authorization.soloAdmin, (req, res) => res.sendFile(__dirname + "/pages/admin/usuarios.html"));
app.get("/creareto", authorization.soloAdmin, (req, res) => res.sendFile(__dirname + "/pages/admin/crearReto.html"));
app.get("/retos", authorization.soloAdmin, (req, res) => res.sendFile(__dirname + "/pages/admin/retos.html"));

app.get("/construccion", authorization.soloUser, (req, res) => res.sendFile(__dirname + "/pages/construccion.html"));

app.post("/api/login", authentication.login);
app.post("/api/register", authentication.register);
app.post('/api/recuperarPass', authentication.recuperarPassword);


// Ruta para manejar el formulario de subida
app.post('/upload', upload.single('logo'), (req, res) => {
    const nombre = req.body.nombre; // Nombre de la empresa
    const logo = req.file; // Archivo subido

    // Mostrar los detalles en consola
    console.log(`Nombre de la empresa: ${nombre}`);
    console.log(`Archivo subido: ${logo.filename}`);

    // Responder al cliente
    res.send('Logo subido con éxito.');
});

sequelize.sync()
    .then(() => {
        console.log('Base de datos sincronizada');
        app.listen(process.env.PORT, () => {
            console.log(`Servidor corriendo en el puerto ${process.env.PORT}`);
        });
    })
    .catch((error) => {
        console.error('Error al sincronizar la base de datos:', error);
    });