document.addEventListener('DOMContentLoaded', () => {
    const form = document.getElementById('crearRetoForm');

    form.addEventListener('submit', async (event) => {
        event.preventDefault(); // Evita el envío predeterminado del formulario
console.log('Formulario enviado'); // Agrega un log para verificar el envío del formulario
        const formData = new FormData(form);

        try {
            const response = await fetch(`${API_BASE_URL}/api/retos`, {
                method: 'POST',
                body: formData,
            });

            if (response.ok) {
                const result = await response.json();
                alert('Reto creado exitosamente');
                console.log(result);
                form.reset(); // Limpia el formulario
            } else {
                const error = await response.json();
                alert('Error al crear el reto');
                console.error(error);
            }
        } catch (err) {
            console.error('Error en la solicitud:', err);
            alert('Ocurrió un error al enviar el formulario');
        }
    });
});